### **Overview**

Cisco Secure Firewall ASA and Threat Defense support IPsec VPN configurations with significant differences in approach, management, and features.

---

### **VPN Configuration Approaches**

#### **Cisco Secure Firewall ASA**

- **Crypto Map-Based Configuration**:
    - Policy-based configuration.
    - Encrypts only a subset of traffic based on a crypto access control list (ACL) applied to the crypto map.
- **Virtual Tunnel Interface (VTI)-Based Configuration**:
    - Supported from software Version 9.7 and later.
    - Route-based configuration where all traffic entering the virtual interface is encrypted.

#### **Cisco Secure Firewall Threat Defense**

- **Crypto Map-Based Configuration**:
    - Similar to ASA.
- **Static and Dynamic VTIs**:
    - Supported from version 7.2 (Static VTI) and 7.3 (Dynamic VTI).

---

### **Management Options**

#### **Cisco Secure Firewall ASA**

- **CLI**:
    - Traditional configuration method.
    - Requires configuration of IKE policy, transform-set, crypto ACL, crypto map, and tunnel group.
- **Cisco Adaptive Security Device Manager (ASDM)**:
    - Web-based interface for simplified configuration.
    - Includes Site-to-Site VPN Wizard for easier setup.

#### **Cisco Secure Firewall Threat Defense**

- **Cisco Secure Firewall Device Manager**:
    - On-box graphical manager for small or mid-size networks.
    - Supports site-to-site VPN configuration.
- **Cisco Secure Firewall Management Center**:
    - Centralized management for multiple devices.
    - VPN configuration is performed by deploying a VPN topology.

---

### **Supported IPsec VPN Features**

#### **Cisco Secure Firewall ASA**

- **IKE Versions**:
    - Supports IKEv1 and IKEv2 [[Internet Key Exchange version 2 (IKEv2)]]
- **Authentication**:
    - Digital certificates or pre-shared keys (PSKs).
    - Asymmetric authentication supported with IKEv2.
- **Routing Across VPN Tunnel**:
    - Static routing or Reverse Route Injection (RRI).
    - Dynamic routing via Border Gateway Protocol (BGP) in VTIs.

#### **Cisco Secure Firewall Threat Defense**

- **IKE Versions**:
    - Supports IKEv1 and IKEv2.
- **Authentication**:
    - Digital certificates or PSKs (no asymmetric authentication for IKEv2).
    - Management Center can automate PSK generation and configuration for multiple devices.
- **Routing Across VPN Tunnel**:
    - Crypto Map VPN: Static routing or RRI.
    - VTI-Based VPN: BGP and static routes.
    - OSPF and EIGRP dynamic routing support for VTIs (Version 7.3.0+).

---

### **Deployment Considerations**

#### **Traffic Filtering and NAT**

- **Traffic Filtering**:
    - **ASA**: VPN traffic is allowed by default unless overridden.
    - **Threat Defense**: VPN traffic is processed by Access Control Policy (ACP) and must be explicitly allowed.
- **NAT Configuration**:
    - Ensure VPN traffic does not match existing NAT rules.
    - Configure NAT exemption if necessary.
    - NAT is performed before encryption; misconfigured NAT can prevent traffic from being encrypted.

#### **Routing**

- Ensure correct routing for remote networks:
    - For VTIs: Routing table should point to the local tunnel interface.
    - For Crypto Maps: Routing table should point to the interface with the crypto map applied.

---

### **Conclusion**

Cisco Secure Firewall ASA and Threat Defense provide robust IPsec VPN capabilities with differences in configuration approaches, management tools, and supported features. Proper consideration of traffic filtering, NAT, and routing is essential for successful deployment.